<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Comment extends Model 
{

    protected $table = 'comments';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('id_user', 'id_post', 'content', 'rate');
    protected $visible = array('id_user', 'id_post', 'content', 'rate');

    public function user()
    {
        return $this->belongsTo('App\Models\User', 'id_user');
    }

    public function post()
    {
        return $this->belongsTo('App\Models\Post', 'id_post');
    }

}